string GetDescription()
{
	return "Creates a simple melody that follows the changes of the phrases";
}

double GetEventLength(UniquePart @up, int e)
{
	Time t1 = up.GetEventStart(e);
	Time t2 = up.GetEventEnd(e);
	return (t2.m_Bar - t1.m_Bar) * up.GetMetrum() + (t2.m_Pos - t1.m_Pos);
}

void CreateMelody(UniquePart @up)
{
	int u_phrases = up.GetUniquePhrases();
	
	int[][] melody(u_phrases);
	int[][] align(u_phrases);
	
	for (int i = 0; i < u_phrases; i++)
	{
		UniquePhrase @p = up.GetUniquePhrase(i);		
		melody[i].resize(p.GetEvents());
		align[i].resize(p.GetEvents());
		for (int m = 0; m < p.GetEvents(); m++)
		{
			melody[i][m] = RndInt(-2,2);
			align[i][m] = RndInt(0,1);
		}
		
		melody[i][0] = RndInt(2,8);
	}
	
	int event = 0;
	int note = 0;
	
	for (int s = 0; s < up.GetSentences(); s++)
	{
		for (int p = 0; p < up.GetSentence(s).GetPhrases(); p++)
		{
			UniquePhrase @upp = up.GetSentence(s).GetPhrase(p).GetUniquePhrase();		
			
			int note = melody[up.GetSentence(s).GetPhrase(p).GetUniquePhraseID()][0];
			
			for (int e = 0; e < upp.GetEvents(); e++)
			{
				if (event < up.GetEvents()-1)
				{
					if ( align[up.GetSentence(s).GetPhrase(p).GetUniquePhraseID()][e] == 1 || GetEventLength(up, event) > 1.2)
					{
						up.SetEventPitch(event, up.AlignPitchToHarm(event,note));				
					}
					else 
					{
						up.SetEventPitch(event, note);				
					}
					
					event++;
					if ( e < upp.GetEvents()-1) note += melody[up.GetSentence(s).GetPhrase(p).GetUniquePhraseID()][e+1];
				}
			}
		}		
	}
	
	int last_note = 1;
	
	if (up.EndsSong())
	{
		if (RndInt(0,3) == 0) last_note = 5;
	}
	else
	{
		if (RndInt(0,2) != 0) last_note = 1 + (RndInt(0,2) * 2);
	}
	
	while (note > 5)
	{
		note -= 7;
		last_note +=7;	
	}
	
	while (note < -3)
	{
		note += 7;
		last_note -=7;	
	}
	
	if (note == 5 && RndInt(0,1) == 0) last_note+=7;
		
	up.SetEventPitch(up.GetEvents()-1, last_note);	
	
	
}